import json
import os
import requests
from requests.auth import HTTPBasicAuth
from getpass import getpass

# Function to create .m3u file
def create_m3u_file(filename, val, key):
    content = f"#EXTM3U\n#EXTINF:-1,{val}\nhttp://raspberrypi.local:9981/stream/channel/{key}\n"
    with open(filename, 'w') as file:
        file.write(content)

# Prompt for username and password
username = input("Enter your username: ")
password = getpass("Enter your password: ")

# Fetch JSON data from URL with basic authentication
url = 'http://raspberrypi.local:9981/api/channel/list'

try:
    response = requests.get(url, auth=HTTPBasicAuth(username, password))
    response.raise_for_status()  # Check for HTTP errors
    data = response.json()
except requests.exceptions.RequestException as e:
    print(f"Error fetching JSON data: {e}")
    exit(1)

# Check if data contains 'entries' key
if 'entries' not in data:
    print("Error: JSON data does not contain 'entries' key")
    exit(1)

# Create .m3u files
for item in data['entries']:
    if not isinstance(item, dict):
        print(f"Error: Item {item} is not a dictionary")
        continue
    try:
        val = item['val'].strip()
        key = item['key']
        filename = f"{val.replace(' ', '')}.m3u"
        create_m3u_file(filename, val, key)
    except KeyError as e:
        print(f"Error: Missing key {e} in item {item}")

print("M3U files created successfully!")
